local colMap = {
	["Amulet"] = "AmuletMod",
	["Ring"] = "RingMod",
	["Belt"] = "BeltMod",
	["Quiver"] = "QuiverMod",
	["Helmet"] = "HelmetMod",
	["Body Armour"] = "BodyArmourMod",
	["Boots"] = "BootsMod",
	["Gloves"] = "GlovesMod",
	["Shield"] = "ShieldMod",
	["Bow"] = "BowMod",
	["Claw"] = "ClawMod",
	["Dagger"] = "DaggerMod",
	["Staff"] = "StaffMod",
	["Wand"] = "WandMod",
	["One Handed Axe"] = "OneHandAxeMod",
	["One Handed Mace"] = "OneHandMaceMod",
	["One Handed Sword"] = "OneHandSwordMod",
	["Sceptre"] = "SceptreMod",
	["Thrusting One Handed Sword"] = "ThrustingOneHandSwordMod",
	["Two Handed Axe"] = "TwoHandAxeMod",
	["Two Handed Mace"] = "TwoHandMaceMod",
	["Two Handed Sword"] = "TwoHandSwordMod",
}
local out = io.open("../Data/3_0/Essence.lua", "w")
out:write('-- This file is automatically generated, do not edit!\n')
out:write('-- Item data (c) Grinding Gear Games\n\nreturn {\n')
for essence in dat"Essences":Rows() do
	if essence.Tier > 0 then
		out:write('\t["', essence.BaseItemType.Id, '"] = { name = "', essence.BaseItemType.Name, '", ')
		out:write('type = ', essence.Type._rowIndex - 1, ', tier = ', essence.Tier, ', ')
		out:write('mods = { ')
		for type, col in pairs(colMap) do
			out:write('["', type, '"] = "', essence[col].Id, '", ')
		end
		out:write('}, },\n')
	end
end
out:write('}')
out:close()

print("Essences exported.")
